package cn.com.duiba.live.normal.service.api.param.oto;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * OTO-销售列表分页查询参数
 *
 * @author ZhangJun
 * @date 2022/1/5 7:38 下午
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoSellerPageListParam extends PageQuery {

    private static final long serialVersionUID = -9206343841720838429L;

    /**
     * 销售手机号
     */
    private String phoneNumber;

    /**
     * 销售名称
     */
    private String sellerName;

    /**
     * 角色类型
     */
    private Integer roleType;

    /**
     * 销售所在地区
     */
    private String sellerArea;

    /**
     * 所属公司id
     */
    private Long companyId;

    /**
     * 销售等级,1=A,2=B,3=C
     */
    private Integer sellerLevel;

    /**
     * 工作状态,0-非工作中,1=工作中
     */
    private Integer workStatus;

    /**
     * 所属上级销售id
     */
    private Long parentId;
}
