package cn.com.duiba.live.normal.service.api.param.oto.cust;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * OTO-客户回收池列表分页查询参数
 *
 * @author ZhangJun
 * @date 2022/1/5 7:38 下午
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoCustRecyclePageListParam extends PageQuery {

    private static final long serialVersionUID = -210708968627650589L;

    /**
     * 分配状态,0-待分配，1-已分配
     * {@link cn.com.duiba.live.normal.service.api.enums.oto.cust.OtoCustAssignStatusEnum}
     */
    private Integer assignStatus;

    /**
     * 客户所属保险公司id,tb_oto_company.id
     */
    private Long custCompany;

    /**
     * 所处资源池类型
     *
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.OtoCustPoolEnum
     */
    private List<Integer> poolTypes;
}
