package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.Getter;

/**
 * oto 客户来源枚举
 *
 * @author xuanhongjian
 */
@Getter
public enum CustSourceEnum {
    /**
     * 1:原顾客户 2:转介绍客户 3:表单客户 4.直播客户 5.助手客户
     */
    FORM("表单客户", 3),
    INTRODUCE("转介绍客户", 2),
    ORIGINAL("原顾客户", 1),
    LIVE("直播客户", 4),
    ASSISTANT("助手客户", 5);
    private static final ImmutableMap<Integer, CustSourceEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, CustSourceEnum> builder = ImmutableMap.builder();
        for (CustSourceEnum item : CustSourceEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    private final String desc;
    private final Integer code;

    CustSourceEnum(String desc, Integer code) {
        this.desc = desc;
        this.code = code;
    }

    @SuppressWarnings("unused")
    public static CustSourceEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }
}
