package cn.com.duiba.live.normal.service.api.dto.oto.seller;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author chenzhenxing
 * @date 2022/3/27 5:42 下午
 */
@Data
public class SellerNotifyDto implements Serializable {
    private static final long serialVersionUID = 855486698800452423L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 销售id,tb_oto_seller.id
     */
    private Long sellerId;

    /**
     * 客户id,tb_oto_customer.id
     */
    private Long custId;

    /**
     * 通知类型,0=其它通知,1=上传预约参观记录,2=强制分配客户,3=日程通知,4=社区预约参观通知
     */
    private Integer notifyType;

    /**
     * 通知完成情况,0=其它,1=未完成,2=已取消,3=已完成
     * @see cn.com.duiba.live.normal.service.api.enums.oto.OtoSellerNotifyStatusEnum
     */
    private Integer notifyStatus;

    /**
     * 通知时间
     */
    private Date notifyTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
