package cn.com.duiba.live.normal.service.api.remoteservice.oto.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.CustCallRecordDto;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-16 10:00
 */
@AdvancedFeignClient
public interface RemoteCustCallRecordService {

    /**
     * 根据日志id获取通话记录
     * @param callLogId 日志id
     * @return 通话记录
     */
    CustCallRecordDto findByCallLogId(Long callLogId);

    /**
     * 保存通话记录
     *
     * @param custCallRecordDto 通话记录
     * @return 保存结果
     */
    boolean save(CustCallRecordDto custCallRecordDto);
}
