package cn.com.duiba.live.normal.service.api.remoteservice.oto.product;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.base.api.request.Result;
import cn.com.duiba.live.normal.service.api.dto.oto.product.OtoProductDto;
import cn.com.duiba.live.normal.service.api.param.oto.product.ProductSearchParam;

import java.util.List;

/**
 * @author MeiChang
 * @Description
 */
@AdvancedFeignClient
public interface RemoteOtoProductService {
    /**
     * 新增、编辑产品
     *
     * @param productDto
     * @return
     */
    Result<Boolean> save(OtoProductDto productDto);

    /**
     * 产品详情
     *
     * @param id
     * @return
     */
    OtoProductDto detail(Long id);

    /**
     * 上、下架产品
     *
     * @param id
     * @return
     */
    Boolean updateStatus(Long id);

    /**
     * 多条件分页查询产品列表
     *
     * @param param
     * @return
     */
    List<OtoProductDto> list(ProductSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(ProductSearchParam param);

    /**
     * 校验参数
     * @param param
     * @return
     */
    Boolean checkProduct(ProductSearchParam param);

}
