package cn.com.duiba.live.normal.service.api.dto.oto.interview;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data
public class InterviewDTO implements Serializable {
    private static final long serialVersionUID = 6315795252485522755L;
    /** 主键id */
    private Long id;

    /** 客户ID */
    private Long customerId;

    /** 销售ID */
    private Long sellerId;

    /** 面访类型 */
    private Integer interviewType;

    /** 面访状态：{@link cn.com.duiba.live.normal.service.api.enums.oto.OtoCustInterviewStatusEnum} */
    private Integer interviewStatus;

    /** 是否提交计划书 */
    private Integer commitPlanFlag;

    /** 提交计划书后客户状态 */
    private Integer commitCustStatus;

    /** 提交时间 */
    private Date commitTime;

    /** 面访地址 */
    private String interviewAddress;

    /** 面访地址的经度 */
    private String interviewLongitude;

    /** 面访地址的纬度 */
    private String interviewLatitude;

    /** 客户评价 */
    private String evaluateDetail;

    /** 面访客户扫码类型 */
    private Integer scanCodeType;

    /** 扫码者对应userId tb_users表 id */
    private Long scanUserId;

    /** 面访码ID tb_mp_qrcode表主键 */
    private Long scanCodeId;

    /** 面访备注 */
    private String interviewRemark;

    /** 面访时间 */
    private Date interviewTime;

    /** 预约时间 */
    private Date appointmentTime;

    /** 客户权重 1:A 2:B 3:C */
    private Integer followWeight;

    /** 客户价值 */
    private Integer custValue;

    /** 核心决策人 1："不明或其他" 2:"自己" 3："配偶" 4："子女" 5："父母" */
    private Integer coreMaker;

    /** 创建时间 */
    private Date gmtCreate;

    /** 更新时间 */
    private Date gmtModified;
}
