package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import com.google.common.collect.ImmutableMap;
import lombok.Getter;

import java.util.Objects;

/**
 * OTO 流程组名称
 *
 * @author MeiChang
 * @Description
 */
@Getter
public enum CustFlowEnum {
    /**
     * 流程组名称 1:具备机构养老理念 2:认同公司养老解决方案 3:认同你的保险方案 4.当下成交 5.已成单
     */
    HAVE_IDEA(1, "具备机构养老理念"),
    AGREE_SOLVE(2, "认同公司养老解决方案"),
    AGREE_PROJECT(3, "认同你的保险方案"),
    NOW_TRADING(4, "当下成交"),
    HAVE_ORDER(5, "已成单"),
    ;

    private static final ImmutableMap<Integer, CustFlowEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, CustFlowEnum> builder = ImmutableMap.builder();
        for (CustFlowEnum value : CustFlowEnum.values()) {
            builder.put(value.code, value);
        }
        INNER_MAP = builder.build();
    }

    private final Integer code;
    private final String desc;

    CustFlowEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CustFlowEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }
}
