package cn.com.duiba.live.normal.service.api.param.oto.interview;

import lombok.Data;

import java.io.Serializable;

/**
 * 描述：
 *
 * @author zhouziwu
 * @date 2022-03-25
 */
@Data
public class InterviewFeedbackParam implements Serializable {

    /** 面访备注 */
    private String interviewRemark;

    /** 面访主键ID */
    private Long id;

    /** 客户ID */
    private Long custId;

    /** 核心决策人 */
    private Integer coreMaker;

    /** 客户跟进权重 */
    private Integer followWeight;

    /**
     *  是否提交养老计划方案
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitPlanFlag;

    /**
     * 客户是否已确认投保要素  0:否 1：是
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitInsure;

    /**
     * 产品id
     */
    private Long productId;

    /**
     * 投保人
     */
    private Integer insApplicant;

    /**
     * 被投保人
     */
    private Integer insByApplicant;

    /**
     * 投保金额
     */
    private Integer insMoney;

    /**
     * 投保期数
     */
    private Integer insPeriod;

}
