/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.normal.service.api.enums.oto;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OtoTagStatusEnum {
    CLOSE(0, "\u5173\u95ed"),
    OPEN(1, "\u5f00\u542f");

    private Integer tagStatus;
    private String desc;
    private static final Map<Integer, OtoTagStatusEnum> ENUM_MAP;

    public static OtoTagStatusEnum getByTagStatus(Integer tagStatus) {
        if (Objects.isNull(tagStatus)) {
            return null;
        }
        return ENUM_MAP.get(tagStatus);
    }

    public Integer getTagStatus() {
        return this.tagStatus;
    }

    public String getDesc() {
        return this.desc;
    }

    private OtoTagStatusEnum(Integer tagStatus, String desc) {
        this.tagStatus = tagStatus;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(OtoTagStatusEnum.values()).collect(Collectors.toMap(OtoTagStatusEnum::getTagStatus, Function.identity(), (v1, v2) -> v1)));
    }
}

