/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.OtoCustStatusEnum;
import cn.com.duiba.live.normal.service.api.util.NumberUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OtoCustPoolEnum {
    WAIT_POOL(1, 0, "\u9884\u5907\u6c60"),
    FRESH_POOL(2, 0, "\u6295\u653e\u6c60"),
    FOLLOW_POOL(3, 1, "\u8ddf\u8fdb\u6c60"),
    RECYCLE_POOL(4, 2, "\u56de\u6536\u6c60"),
    GARBAGE_POOL(5, 3, "\u5783\u573e\u6c60");

    private Integer poolType;
    private Integer custStatus;
    private String desc;
    private static final Map<Integer, OtoCustPoolEnum> ENUM_MAP;
    private static final List<OtoCustPoolEnum> CLAIM_POOLS;
    private static final Map<Integer, List<Integer>> POOL_STATUS_MAP;

    public static List<Integer> claimPools() {
        return CLAIM_POOLS.stream().map(OtoCustPoolEnum::getPoolType).collect(Collectors.toList());
    }

    public static boolean canClaim(Integer poolType) {
        if (NumberUtil.isNullOrLteZero(poolType)) {
            return false;
        }
        return OtoCustPoolEnum.claimPools().contains(poolType);
    }

    public static OtoCustPoolEnum getByPoolType(Integer poolType) {
        if (Objects.isNull(poolType)) {
            return null;
        }
        return ENUM_MAP.get(poolType);
    }

    public static List<Integer> convertCustStatus2PoolTypes(Integer custStatus) {
        return Collections.unmodifiableList(Arrays.stream(OtoCustPoolEnum.values()).filter(item -> Objects.equals(item.getCustStatus(), custStatus)).map(OtoCustPoolEnum::getPoolType).collect(Collectors.toList()));
    }

    public Integer getPoolType() {
        return this.poolType;
    }

    public Integer getCustStatus() {
        return this.custStatus;
    }

    public String getDesc() {
        return this.desc;
    }

    private OtoCustPoolEnum(Integer poolType, Integer custStatus, String desc) {
        this.poolType = poolType;
        this.custStatus = custStatus;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(OtoCustPoolEnum.values()).collect(Collectors.toMap(OtoCustPoolEnum::getPoolType, Function.identity())));
        CLAIM_POOLS = Collections.unmodifiableList(Lists.newArrayList((Object[])new OtoCustPoolEnum[]{FRESH_POOL, RECYCLE_POOL}));
        POOL_STATUS_MAP = Maps.newHashMap();
        POOL_STATUS_MAP.put(OtoCustStatusEnum.WAIT_ASSIGN.getCustStatus(), Lists.newArrayList((Object[])new Integer[]{OtoCustPoolEnum.WAIT_POOL.poolType, FRESH_POOL.getPoolType()}));
        POOL_STATUS_MAP.put(OtoCustStatusEnum.ASSIGNED.getCustStatus(), Lists.newArrayList((Object[])new Integer[]{OtoCustPoolEnum.FOLLOW_POOL.poolType}));
        POOL_STATUS_MAP.put(OtoCustStatusEnum.RECYCLED.getCustStatus(), Lists.newArrayList((Object[])new Integer[]{OtoCustPoolEnum.RECYCLE_POOL.poolType}));
        POOL_STATUS_MAP.put(OtoCustStatusEnum.GARBAGE_POOL.getCustStatus(), Lists.newArrayList((Object[])new Integer[]{GARBAGE_POOL.getPoolType()}));
    }
}

