package cn.com.duiba.live.normal.service.api.dto.pub.form;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 公域引流-表单测评提交记录
 *
 * @author kjj mybatis generator
 * @date 2021-09-29
 */
@Data
public class PubFormRecordDto implements Serializable {

    private static final long serialVersionUID = 16336043172268462L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 表单id tb_pub_form.id
     */
    private Long formId;

    /**
     * 用户名
     */
    private String username;

    /**
     * 用户手机号
     */
    private String phoneNum;

    /**
     * 手机号归属地
     */
    private String phoneLocation;

    /**
     * 客户等级
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.OtoCustLevelEnum
     */
    private Integer custLevel;

    /**
     * 用户手机号验证状态 0-未验证 1-已验证
     * @see cn.com.duiba.live.normal.service.api.enums.pub.form.PhoneAuthStatusEnum
     */
    private Integer phoneAuthStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 链接地址
     */
    private String urlLink;

    /**
     * 标签 标签 -1=其他 0=暂无 1=有效 2=无效
     * @see cn.com.duiba.live.normal.service.api.enums.pub.form.RecordLabelEnum
     */
    private Integer recordLabel;

    /**
     * 回传状态  0=未回传 1=已回传
     * @see cn.com.duiba.live.normal.service.api.enums.pub.form.RecordCallbackStatusEnum
     */
    private Integer callbackStatus;

    /**
     * 操作人员
     */
    private String recordEditor;

    /**
     * 备注
     */
    private String recordRemark;

    /**
     * uuid
     */
    private String recordUuid;

    /**
     * 表单提交类型  0-表单提交  1-Excel导入
     * @see cn.com.duiba.live.normal.service.api.enums.pub.form.RecordTypeEnum
     */
    private Integer recordType;
}
