package cn.com.duiba.live.normal.service.api.param.oto.seller;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户面访场景配置表
 * @author kjj mybatis generator 
 * @date 2022-05-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InterviewSceneConfSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16528520048598885L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 场景名称
     */
    private String sceneName;

    /**
     * 场景描述
     */
    private String sceneDesc;

    /**
     * 客户阶流程组名称，多个逗号分隔 1:具备机构养老理念 2:认同公司养老解决方案 3:认同你的保险方案 4.当下成交
     */
    private String custFlows;

    /**
     * 适用公司 tb_oto_company.id,多个逗号分隔
     */
    private String companyIds;

    /**
     * 配置是否启用状态： 0-否  1-是
     */
    private Byte confUsable;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}