package cn.com.duiba.live.normal.service.api.remoteservice.oto.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.seller.InterviewSceneConfDto;
import cn.com.duiba.live.normal.service.api.param.oto.seller.InterviewSceneConfSearchParam;

import java.util.List;

/**
 * @Author meichang
 * @Date 2022/5/18 13:50
 * @Version 1.0
 */
@AdvancedFeignClient
public interface RemoteOtoSceneConfService {

    /**
     * 新增、编辑面试场景配置
     * @param interviewSceneConfDto
     * @return 是否成功
     */
    Boolean saveOrUpdateInterviewSceneConf(InterviewSceneConfDto interviewSceneConfDto);

    /**
     * 根据id修改场景配置状态--启用/禁用
     */
    Boolean updateSceneConfStatusById(Long id);

    /**
     * 根据id查询场景配置
     */
    InterviewSceneConfDto getInterviewSceneConfById(Long id);

    /**
     * 分页查询场景配置
     */
    List<InterviewSceneConfDto> listSceneConf(InterviewSceneConfSearchParam param);

    /**
     * 查询场景配置总数
     * @return
     */
    Long listSceneConfCount();

}
