package cn.com.duiba.live.normal.service.api.dto.oto.cust;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author xuanhongjian
 */
@Data
public class MyCustomerListForPhoneDto implements Serializable {

    private static final long serialVersionUID = 8475570796305812615L;

    /***
     * 客户ID
     */
    private Long id;

    /**
     * 客户姓名
     */
    private String custName;

    /**
     * 客户来源 
     */
    private Integer custSource;

    /**
     * 客户阶流程组名称 0: 客户待分配 1:具备机构养老理念 2:认同公司养老解决方案 3:认同你的保险方案 4.当下成交 5.已成单
     */
    private Integer custFlow;

    /**
     * 通话次数
     */
    private Integer callNum;

    /**
     * 线下拜访次数
     */
    private Integer interviewNum;

    /**
     * 标签
     */
    private List<String> custTags;

    /**
     * 跟进时间 需要按照次字段降序排序
     */
    private Date lastFollowTime;

    public MyCustomerListForPhoneDto(Long id) {
        this.id = id;
    }

    public MyCustomerListForPhoneDto() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MyCustomerListForPhoneDto phoneDto = (MyCustomerListForPhoneDto) o;
        return id.equals(phoneDto.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
