package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * OTO 流程组名称
 *
 * @author MeiChang
 * @Description
 */
@Getter
public enum CustFlowEnum {
    /**
     * 流程组名称 1:具备机构养老理念 2:认同公司养老解决方案 3:认同你的保险方案 4.当下成交 5.已成单
     */
    HAVE_IDEA(1, "具备机构养老理念"),
    AGREE_SOLVE(2, "认同公司养老解决方案"),
    AGREE_PROJECT(3, "认同你的保险方案"),
    NOW_TRADING(4, "当下成交"),
    HAVE_ORDER(5, "已成单"),
    ;

    private static final Map<Integer, CustFlowEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CustFlowEnum::getCode, Function.identity(), (v1, v2)->v1)));;


    private final Integer code;
    private final String desc;

    CustFlowEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CustFlowEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code){
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
