package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 您觉得退休后到底要准备多少退休金才够用
 * @Author meichang
 * @Date 2022/5/18 19:53
 * @Version 1.0
 */
@AllArgsConstructor
@Getter
public enum OtoCustPensionSalaryEnum {
    TWO_MILLION(1, "200万元"),
    THREE_MILLION(2, "300万元"),
    FIVE_MILLION(3, "500万元"),
    SEVEN_MILLION(4, "700万元"),
    TEN_MILLION(5, "1000万元"),
    TEN_MILLION_ON(6, "1000万元以上"),
    NONE(0, "尚未选择");


    /**
     * 编码
     */
    private final Integer code;

    /**
     * 备注
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustPensionSalaryEnum::getCode, OtoCustPensionSalaryEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据状态获取描述
     */
    public static String getDescByStatus(Integer status){
        if (status == null) {
            return null;
        }
        return ALL_MAP.get(status);
    }
}
