package cn.com.duiba.live.normal.service.api.dto.oto.seller;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 任务配置表
 * @author kjj mybatis generator 
 * @date 2022-04-22
 */
@Data
public class SellerTaskConfDto implements Serializable {
     
    private static final long serialVersionUID = 16506135785504502L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 客户状态 1-未联系过，2-未打通过，3-长时间未联系
     */
    private Integer custConfStatus;

    /**
     * 客户状态数值限制范围下限
     */
    private Integer custStatusMinLimit;

    /**
     * 客户状态数值限制范围上限
     */
    private Integer custStatusMaxLimit;

    /**
     * 客户类型：1:全部客户、2:新客户、3:老客户、
     */
    private Integer custType;

    /**
     * 客户来源：多个用逗号分隔 tb_oto_customer.cust_source
     */
    private List<Long> custSourceList;

    /**
     * 是否限制任务量: 0-否  1-是
     */
    private Integer limitGoalFlag;

    /**
     * 限制条件：总客户数*x%
     */
    private Integer conditionLimit;

    /**
     * 任务是否启用状态： 0-否  1-是
     */
    private Integer taskUsable;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}