package cn.com.duiba.live.normal.service.api.enums.oto;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 描述：告知书签署状态
 *
 * @author zhouziwu
 * @date 2022-05-26
 */
@AllArgsConstructor
@Getter
public enum OtoNotificationSignatureStateEnum {

    /** 待签名 */
    NO_SIGNATURE(0, "待签名"),

    /** 销售签名 */
    SELLER_SIGNATURE(1, "销售签名"),

    /** 客户签名 */
    CUSTOMER_SIGNATURE(2, "客户签名"),

    /** 销售客户都签名 */
    ALL_SIGNATURE(3, "销售客户都签名"),

    /** 已失效 */
    INVALID_SIGNATURE(4, "已失效"),

    ;

    private final Integer code;
    private final String desc;
}
