package cn.com.duiba.live.normal.service.api.param.oto.interview;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.visit.OtoCustCommitStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 描述：
 *
 * @author zhouziwu
 * @date 2022-03-25
 */
@Data
public class InterviewFeedbackParam implements Serializable {

    /** 面访备注 */
    private String interviewRemark;

    /** 面访主键ID */
    private Long id;

    /** 核心决策人 */
    private Integer coreMaker;

    /** 客户关注度 */
    private Integer followWeight;

    /**
     *  是否提交养老计划方案
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitPlanFlag;

    /**
     * 提交方案后客户状态 1近期有机会成交 2近期无法成交 3拒绝
     * @see OtoCustCommitStatusEnum
     */
    private Integer commitCustStatus;

    /**
     * 客户是否已确认投保要素  0:否 1：是
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitInsure;

    /**
     * 客户未确认投保要素的原因
     */
    private String insureReason;

    /**
     * 产品id
     */
    private Long productId;

    /**
     * 投保人
     */
    private Integer insApplicant;

    /**
     * 被投保人
     */
    private Integer insByApplicant;

    /**
     * 投保金额
     */
    private Integer insMoney;

    /**
     * 投保期数
     */
    private Integer insPeriod;

    /**
     * 面访异常类型
     */
    private String unusualTypes;

    /**
     * 面访说明
     */
    private String unusualExplain;

    /**
     * 上传凭证
     */
    private String unusualProofs;

    /**
     * 是否是异常上传面访详情 false:否
     */
    private Boolean isNormal = true;
}
