package cn.com.duiba.live.normal.service.api.remoteservice.oto.notification;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.notification.NotificationRecordDTO;
import cn.com.duiba.live.normal.service.api.param.oto.notification.NotificationRecordSaveParam;
import cn.com.duiba.live.normal.service.api.param.oto.notification.NotificationRecordSearchParam;
import cn.com.duiba.live.normal.service.api.param.oto.notification.NotificationRecordUpdateParam;
import cn.com.duiba.live.normal.service.api.param.oto.notification.NotificationRecordUpdateUrlParam;
import cn.com.duiba.live.normal.service.api.util.PageResult;

/**
 * 描述：
 *
 * @author zhouziwu
 * @date 2022-05-26
 */
@AdvancedFeignClient
public interface RemoteOtoNotificationService {

    /**
     * 查询告知书信息，分页
     * @param param 查询条件
     * @return 告知书详情
     */
    PageResult<NotificationRecordDTO> list(NotificationRecordSearchParam param);

    /**
     * 告知书新增
     * @param param 新增的告知书信息
     * @return 保存结果
     */
    Boolean save(NotificationRecordSaveParam param);

    /**
     * 告知书编辑更新
     * @param param 更新的参数
     * @return 更新结果
     */
    Boolean update(NotificationRecordUpdateParam param);

    /**
     * 根据id获取
     * @param id 告知书主键
     * @return 告知书详情
     */
    NotificationRecordDTO getDetail(Long id);

    /**
     * 客户告知书签字提交
     * @param param 提交更新的信息
     * @return 更新结果
     */
    Boolean updateSignatureInfo(NotificationRecordUpdateUrlParam param);
}
