package cn.com.duiba.live.normal.service.api.enums.pub.form.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 公域引流-客户管理交易完成枚举
 *
 * @author xiaocong
 * @date 2021/11/17 8:04 下午
 */
@Getter
@AllArgsConstructor
public enum PubFormTradeFinishEnum {

    /**
     * 否
     */
    UN_FINISH(0, "否"),

    /**
     * 是
     */
    FINISH(1, "是");

    /**
     * code
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String description;


    public static final Map<Integer, String> TRADE_MAP;

    static {
        Map<Integer, String> map = Arrays.stream(values()).collect(Collectors.toMap(PubFormTradeFinishEnum::getCode, PubFormTradeFinishEnum::getDescription));
        TRADE_MAP = Collections.unmodifiableMap(map);
    }
}
