package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 除了退休养老规划，您还希望了解的有关家庭财富的板块有哪些
 * @Author meichang
 * @Date 2022/5/18 19:53
 * @Version 1.0
 */
@AllArgsConstructor
@Getter
public enum OtoCustPensionOtherEnum {
    INVESTMENTC_ONFIGURATION(1, "家庭投资配置"),
    CHILDREN_INHERIT(2, "子女继承"),
    TAX_PREPARATION(3, "税务筹划"),
    FAMILY_TRUST(4, "家族信托"),
    DEBT_ISOLATION(5, "企业债务防御性隔离"),
    PROPERTY_PRESERVATION(6, "子女婚内财产保全"),
    OTHER(7, "其它"),
    NONE(0, "尚未选择");

    /**
     * 编码
     */
    private final Integer code;

    /**
     * 备注
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustPensionOtherEnum::getCode, OtoCustPensionOtherEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据状态获取描述
     */
    public static String getDescByStatus(Integer status){
        if (status == null) {
            return null;
        }
        return ALL_MAP.get(status);
    }

    /**
     * 根据类型获取描述
     */
    public static String getDescByCodes(String codes){
        if (StringUtils.isBlank(codes)) {
            return null;
        }
        return Arrays.stream(codes.split(",")).map(Integer::parseInt).map(ALL_MAP::get).collect(Collectors.joining(","));
    }
}
