package cn.com.duiba.live.normal.service.api.enums.live;

import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2021-02-06 18:24
 * @descript 直播推广链接 推广类型枚举
 */
public enum LiveSpreadLinkPromotionTypeEnum {

    INNER_PROMOTION(1, "内部推广链接"),
    OUTER_PROMOTION(2, "外部推广链接"),
    ;

    private Integer code;

    private String description;

    LiveSpreadLinkPromotionTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据代码获取枚举
     * @param code
     * @return
     */
    public static LiveSpreadLinkPromotionTypeEnum getByCode(Integer code) {
        for (LiveSpreadLinkPromotionTypeEnum liveSpreadLinkPromotionTypeEnum : LiveSpreadLinkPromotionTypeEnum.values()) {
            if (Objects.equals(liveSpreadLinkPromotionTypeEnum.getCode(), code)) {
                return liveSpreadLinkPromotionTypeEnum;
            }
        }
        return null;
    }
}
