package cn.com.duiba.live.normal.service.api.enums.oto.cust.ext;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 14:03
 */
@Getter
@AllArgsConstructor
public enum OtoCustReasonEnum {

    NEED(0, "刚需"),
    FUTURE(1, "未来"),
    LOOK(2, "了解一下");

    /**
     * 原因
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustReasonEnum::getType, OtoCustReasonEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据类型获取描述
     */
    public static String getDescByType(Integer type){
        if (type == null) {
            return null;
        }
        return ALL_MAP.get(type);
    }
}
