/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.normal.service.api.enums.oto;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum OtoCustTypeEnum {
    ALL_CUST(1, "\u5168\u90e8\u5ba2\u6237"),
    NEW_CUST(2, "\u65b0\u5ba2\u6237"),
    OLD_CUST(3, "\u8001\u5ba2\u6237");

    private Integer code;
    private String desc;
    private static final Map<Integer, String> CUSTOMER_TYPE_MAP;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private OtoCustTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(OtoCustTypeEnum.values()).collect(Collectors.toMap(OtoCustTypeEnum::getCode, OtoCustTypeEnum::getDesc, (v1, v2) -> v1)));
    }
}

