package cn.com.duiba.live.normal.service.api.enums.oto;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 销售权限枚举
 *
 * @author Meicahng
 */
@Getter
@AllArgsConstructor
public enum OtoSellerPermissionEnum {

    /**
     * 禁用
     */
    DISABLE(0, "禁用"),

    /**
     * 启用
     */
    ENABLE(1, "启用"),
    ;

    private Integer sellerPermission;
    private String desc;

    private static final Map<Integer, OtoSellerPermissionEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoSellerPermissionEnum::getSellerPermission, Function.identity(), (v1, v2) -> v1)));

    public static OtoSellerPermissionEnum getBySellerPermission(Integer sellerPermission) {
        if (Objects.isNull(sellerPermission)) {
            return null;
        }

        return ENUM_MAP.get(sellerPermission);
    }

}
