package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-05 17:54
 * 客户信息排序枚举
 */
@Getter
@AllArgsConstructor
public enum OtoCustSortTypeEnum {

    ASSIGN_TIME("last_assign_time desc", "根据最近分配时间降序排序"),
    CUST_STAR_VALUE_ASSIGN_TIME("cust star desc,cust_value desc,last_assign_time desc", "根据客户价值降序排列，相同则最近指派时间降序排序"),
    ASSIGN_TIME_ASC("1", "分配时间正序"),
    ASSIGN_TIME_DESC("2", "分配时间倒序"),
    LAST_FOLLOW_TIME_ASC("3", "最近跟进时间正序"),
    LAST_FOLLOW_TIME_DESC("4", "最近跟进时间倒序"),
    REMAIN_DAYS_ASC("5", "根据剩余天数正序"),
    REMAIN_DAYS_DESC("6", "根据剩余天数倒序"),
    ;

    /**
     * 排序字段
     */
    private final String sortField;

    /**
     * 描述
     */
    private final String desc;
}
