package cn.com.duiba.live.normal.service.api.param.oto.seller;

import cn.com.duiba.live.normal.service.api.enums.oto.OtoCustTypeEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.OtoTaskLimitGoalFlagEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * oto-销售任务配置修改参数
 * @author chenzhenxing
 * @date 2022/4/25 2:16 下午
 */
@Data
public class SellerTaskConfParam implements Serializable {
    private static final long serialVersionUID = -8271612729493406384L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 客户状态 1-未联系过，2-未打通过，3-长时间未联系
     * @see cn.com.duiba.live.normal.service.api.enums.oto.OtoCustConfStatusEnum
     */
    private Integer custConfStatus;

    /**
     * 客户状态数值限制范围下限
     */
    private Integer custStatusMinLimit;

    /**
     * 客户状态数值限制范围上限
     */
    private Integer custStatusMaxLimit;

    /**
     * 客户类型：1:全部客户、2:新客户、3:老客户、
     * @see OtoCustTypeEnum
     */
    private Integer custType;

    /**
     * 客户来源：多个用逗号分隔 tb_oto_customer.cust_source
     */
    private List<String> custSourceList;

    /**
     * 是否限制任务量: 0-否  1-是
     * @see OtoTaskLimitGoalFlagEnum
     */
    private Integer limitGoalFlag;

    /**
     * 限制条件：总客户数*x%
     */
    private Integer conditionLimit;

    /**
     * 任务是否启用状态： 0-否  1-是
     * @see cn.com.duiba.live.normal.service.api.enums.oto.OtoTaskUsableEnum
     */
    private Integer taskUsable;

}
