package cn.com.duiba.live.normal.service.api.remoteservice.oto.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.OtoCustInvitationDto;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.OtoCustInvitationRecordDto;
import cn.com.duiba.live.normal.service.api.param.oto.cust.OtoCustInvitationRecordSearchParam;
import cn.com.duiba.live.normal.service.api.param.oto.cust.OtoCustInvitationSearchParam;

import java.util.List;

/**
 * @author liuyj
 * @date 2022/8/4 09:38
 */
@AdvancedFeignClient
public interface RemoteCustInvitationRecordService {
    /**
     * 根据客户ID和销售ID查询邀约记录详情
     * @param param 查询参数
     */
    List<OtoCustInvitationRecordDto> getDetailByParam(OtoCustInvitationRecordSearchParam param);

    /**
     * 新增邀约记录信息
     * @param param 参数
     * @return 结果
     */
    boolean save(OtoCustInvitationRecordSearchParam param);

    /**
     * 更新邀约记录信息
     * @param param 参数
     * @return 结果
     */
    boolean update(OtoCustInvitationRecordSearchParam param);

    /**
     * 查询邀约记录是否是最新状态=1&承诺时间<=承诺时间查询条件
     * @param param 查询参数
     */
    List<OtoCustInvitationRecordDto> getListByParam(OtoCustInvitationRecordSearchParam param);
}
