package cn.com.duiba.live.normal.service.api.remoteservice.oto.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.OtoCustInvitationDto;
import cn.com.duiba.live.normal.service.api.param.oto.cust.OtoCustInvitationSearchParam;

import java.util.List;

/**
 * @author liuyj
 * @date 2022/8/4 09:38
 */
@AdvancedFeignClient
public interface RemoteCustInvitationService {
    /**
     * 根据客户ID和销售ID查询邀约详情
     * @param param 查询参数
     */
    List<OtoCustInvitationDto> getDetailByCustIdAndSid(OtoCustInvitationSearchParam param);

    /**
     * 根据客户id获取邀约基础信息
     * @param custId 客户id
     * @return 邀约基础信息
     */
    OtoCustInvitationDto findByCustId(Long custId);

    /**
     * 新增邀约基础信息
     * @param param 参数
     * @return 结果
     */
    boolean save(OtoCustInvitationSearchParam param);

    /**
     * 编辑邀约基础信息
     * @param param 参数
     * @return 结果
     */
    boolean update(OtoCustInvitationSearchParam param);

    /**
     * 根据销售ID和承诺时间查询邀约基础信息
     * @param param 查询参数
     */
    List<OtoCustInvitationDto> getAllByCustSidAndInvitationTime(OtoCustInvitationSearchParam param);
}
