package cn.com.duiba.live.normal.service.api.remoteservice.oto.company.ref;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.company.ref.CompanySellerRefDto;
import cn.com.duiba.live.normal.service.api.param.oto.company.ref.CompanySellerRefBatchSearchParam;
import cn.com.duiba.live.normal.service.api.param.oto.company.ref.CompanySellerRefSearchParam;

import java.util.List;

/**
 * @author liuyj
 * @date 2022/6/27 13:36
 */
@AdvancedFeignClient
public interface RemoteCompanySellerRefService {
    /**
     * 批量保存
     * @param params 参数
     * @return 结果
     */
    boolean batchSave(List<CompanySellerRefSearchParam> params);

    /**
     * 批量更新
     * @param params 参数
     * @return 结果
     */
    boolean batchUpdate(List<CompanySellerRefSearchParam> params);

    /**
     * 查询
     * @param param 参数
     * @return 结果
     */
    List<CompanySellerRefDto> list(CompanySellerRefSearchParam param);

    /**
     * 批量查询
     * @param param 参数
     * @return 结果
     */
    List<CompanySellerRefDto> batchList(CompanySellerRefBatchSearchParam param);

    /**
     * 根据销售ID删除原有销售和产品组关系
     * @param sellerId 销售ID
     */
    boolean deleteBySellerId(Long sellerId);
}
