package cn.com.duiba.live.normal.service.api.dto.oto.cust.custAssign.result;

import cn.com.duiba.live.normal.service.api.dto.oto.cust.custAssign.param.CustAssignBaseBean;
import lombok.Data;

import java.io.Serializable;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-06-30 11:43
 */
@Data
public class CustAssignResultBean<T extends CustAssignBaseBean> implements Serializable {

    private static final long serialVersionUID = -7969311948349283344L;

    /**
     * 分配数据
     */
    private T bean;

    /**
     * 分配结果
     */
    private Boolean success;

    /**
     * 错误原因
     */
    private String errorMsg;

    /**
     * 导入成功
     */
    public static <T extends CustAssignBaseBean> CustAssignResultBean<T> success(T bean){
        CustAssignResultBean<T> resultBean = new CustAssignResultBean<>();
        resultBean.setBean(bean);
        resultBean.setSuccess(true);
        return resultBean;
    }

    /**
     * 导入失败
     */
    public static <T extends CustAssignBaseBean> CustAssignResultBean<T> failed(T bean, String message){
        CustAssignResultBean<T> resultBean = new CustAssignResultBean<>();
        resultBean.setBean(bean);
        resultBean.setErrorMsg(message);
        resultBean.setSuccess(false);
        return resultBean;
    }
}
