package cn.com.duiba.live.normal.service.api.param.pub.customer;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 公域引流-客户信息表
 * @author xiaocong
 * @date 2021-11-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PubFormCustomerSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16370671672054305L;

    /**
     * 主键
     */
    private Long id;

    /**
     * tb_pub_form对应的id
     */
    private Long formId;

    /**
     * 来源 0=手动添加 1=自动同步 
     */
    private Integer dataSource;

    /**
     * 姓名
     */
    private String username;

    /**
     * 联系方式
     */
    private String phoneNum;

    /**
     * 用户手机号验证状态 0-未验证 1-已验证
     */
    private Integer phoneAuthStatus;

    /**
     * 渠道
     */
    private String pubChannel;

    /**
     * 分发状态  1=等待电联 2=等待分发 3=等待面访 4=结束
     */
    private Integer distributeStatus;

    /**
     * 接通次数
     */
    private Integer connectTime;

    /**
     * 是否答应加微信 0=否 1=是
     */
    private Integer addWechat;

    /**
     * 是否追加微信 0=否 1=是
     */
    private Integer appendWechat;

    /**
     * 地区
     */
    private String customerArea;

    /**
     * 入住对象
     */
    private String residentPeople;

    /**
     * 性别 0=未选 1=男性 2=女性
     */
    private Integer customerGender;

    /**
     * 年龄
     */
    private Integer customerAge;

    /**
     * 购买人资金情况
     */
    private String customerFunds;

    /**
     * 空闲时间
     */
    private String freeTime;

    /**
     * 了解过的机构
     */
    private String learnOrganization;

    /**
     * 入住人职业
     */
    private String residentProfession;

    /**
     * 关注功能
     */
    private String careFunction;

    /**
     * 客户类型
     */
    private String customerType;

    /**
     * 意向度评估
     */
    private Integer customerSatisfaction;

    /**
     * 备注
     */
    private String managerRemark;

    /**
     * 跟进时间
     */
    private Date followTime;

    /**
     * 代理人是否加微信 0=否 1=是
     */
    private Integer followerAddWechat;

    /**
     * 是否见面 0=否 1=是
     */
    private Integer meetCustomer;

    /**
     * 是否带看 0=否 1=是
     */
    private Integer leadCustomer;

    /**
     * 用户情况反馈
     */
    private String customerSituation;

    /**
     * 见面次数
     */
    private Integer meetTimes;

    /**
     * 用户意向
     */
    private String customerIntention;

    /**
     * 预成交时间
     */
    private String expectedFinishTime;

    /**
     * 是否成交 0=否 1=是
     */
    private Integer tradeFinish;

    /**
     * admin_id
     */
    private Long adminId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 填写表单时间
     */
    private Date formSubmitTime;

    /**
     * 跟进人
     */
    private String customerFollower;

    /**
     * 专家id
     */
    private Long expertSellerId;
}