package cn.com.duiba.live.normal.service.api.remoteservice.oto.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.calendar.CustCalendarSearchParam;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.OtoCustInvitationRecordDto;
import cn.com.duiba.live.normal.service.api.param.oto.cust.OtoCustInvitationRecordSearchParam;

import java.util.List;

/**
 * @author liuyj
 * @date 2022/8/4 09:38
 */
@AdvancedFeignClient
public interface RemoteCustInvitationRecordService {
    /**
     * 根据客户ID和销售ID查询邀约记录详情
     * @param param 查询参数
     */
    List<OtoCustInvitationRecordDto> getDetailByParam(OtoCustInvitationRecordSearchParam param);

    /**
     * 新增邀约记录信息
     * @param param 参数
     * @return 结果
     */
    boolean save(OtoCustInvitationRecordSearchParam param);

    /**
     * 更新邀约记录信息
     * @param param 参数
     * @return 结果
     */
    boolean update(OtoCustInvitationRecordSearchParam param);

    /**
     * 查询邀约记录是否是最新状态=1&承诺时间<=承诺时间查询条件
     * @param param 查询参数
     */
    List<OtoCustInvitationRecordDto> getListByParam(OtoCustInvitationRecordSearchParam param);

    /**
     * 根据日历参数获取邀约记录
     * @param param 日历参数
     * @return 邀约记录
     */
    List<OtoCustInvitationRecordDto> listByCalendarParam(CustCalendarSearchParam param);

    /**
     * 退回邀约组
     * 校验逻辑：
     * 1.退回邀约组的只能是已分配（预期到场）的客户
     * 核心处理逻辑：
     *
     * 1.当前邀约记录，状态修改为待分配（已鸽），清空带看组和专家
     * 2.当前邀约基础信息，状态修改为待分配（已鸽）
     * 3.客户改派给原邀约人
     * 4.加入邀约组任务中（已退回）
     * @param recordId
     * @return
     */
    boolean assignRollback(Long recordId);

}
