/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.normal.service.api.util;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class BatchConsumeBlockingQueue<T> {
    private static final Logger log = LoggerFactory.getLogger(BatchConsumeBlockingQueue.class);
    private final int batchSize;
    private final int maxWaitSize;
    private final int maxWaitTimeMillis;
    private final Consumer<List<T>> batchConsumer;
    private final LinkedBlockingQueue<T> queue4Normal;
    private final LinkedBlockingQueue<T> queue4PerfTest;
    private volatile long lastConsumeTimeMillis4Normal = 0L;
    private volatile long lastConsumeTimeMillis4PerfTest = 0L;
    private Thread scheduleThread;
    private final Thread batchConsumeNormalThread;
    private final Thread batchConsumePerfThread;
    private volatile boolean isStarted = false;
    private final ReentrantLock consumeNormalLock = new ReentrantLock();
    private final Condition normalCondition = this.consumeNormalLock.newCondition();
    private final ReentrantLock consumePerfLock = new ReentrantLock();
    private final Condition perfCondition = this.consumePerfLock.newCondition();
    private volatile String lastPerfTestSceneId = null;
    private volatile boolean isLastTestCluster = false;

    public BatchConsumeBlockingQueue(int capacity, int batchSize, int maxWaitSize, int maxWaitTimeMillis, Consumer<List<T>> batchConsumer) {
        Assert.notNull(batchConsumer, (String)"batchConsumer must not be null");
        Assert.isTrue((maxWaitSize <= 0 || batchSize <= maxWaitSize ? 1 : 0) != 0, (String)"batchSize must be less than or equal to maxWaitSize");
        Assert.isTrue((maxWaitSize > 0 || maxWaitTimeMillis > 0 ? 1 : 0) != 0, (String)"maxWaitSize and maxWaitTimeMillis cannot both be less than or equal to zero");
        if (capacity <= 0) {
            this.queue4Normal = new LinkedBlockingQueue();
            this.queue4PerfTest = new LinkedBlockingQueue();
        } else {
            this.queue4Normal = new LinkedBlockingQueue(capacity);
            this.queue4PerfTest = new LinkedBlockingQueue(capacity);
        }
        this.batchSize = batchSize;
        this.maxWaitSize = maxWaitSize;
        this.maxWaitTimeMillis = maxWaitTimeMillis;
        this.batchConsumer = batchConsumer;
        if (maxWaitTimeMillis > 0) {
            this.scheduleThread = new Thread(this::schedule);
        }
        this.batchConsumeNormalThread = new Thread(this::batchConsumeNormalQueue);
        this.batchConsumePerfThread = new Thread(this::batchConsumePerfQueue);
    }

    private void schedule() {
        while (true) {
            try {
                Thread.sleep(this.maxWaitTimeMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (Thread.currentThread().isInterrupted() || !this.isStarted) break;
            this.signalNormal();
            this.signalPerf();
        }
    }

    private void batchConsumeNormalQueue() {
        InternalPerfTestContext.markAsNormal();
        do {
            try {
                this.batchConsume(this.queue4Normal, this.consumeNormalLock, this.normalCondition);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                log.error("\u89e6\u53d1\u6d88\u8d39\u65f6\u53d1\u751f\u5f02\u5e38", e);
            }
        } while (!Thread.currentThread().isInterrupted() && (this.isStarted || !this.queue4Normal.isEmpty()));
    }

    private void batchConsumePerfQueue() {
        do {
            InternalPerfTestContext.markAsPerfTest((String)this.lastPerfTestSceneId, (boolean)this.isLastTestCluster);
            try {
                this.batchConsume(this.queue4PerfTest, this.consumePerfLock, this.perfCondition);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                log.error("\u89e6\u53d1\u6d88\u8d39\u65f6\u53d1\u751f\u5f02\u5e38", e);
            }
            finally {
                InternalPerfTestContext.markAsNormal();
            }
        } while (!Thread.currentThread().isInterrupted() && this.isStarted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchConsume(BlockingQueue<T> queue, ReentrantLock lock, Condition condition) throws InterruptedException {
        List<T> list;
        lock.lockInterruptibly();
        try {
            if (this.isStarted) {
                while (this.needWait(queue) && this.isStarted) {
                    condition.await();
                }
            }
            list = this.drainTo(queue);
        }
        finally {
            lock.unlock();
        }
        if (list.isEmpty()) {
            return;
        }
        this.batchConsumer.accept(list);
    }

    private void signal() {
        if (InternalPerfTestContext.isCurrentInPerfTestMode()) {
            this.signalPerf();
        } else {
            this.signalNormal();
        }
    }

    private void signalNormal() {
        ReentrantLock lock = this.consumeNormalLock;
        lock.lock();
        try {
            this.normalCondition.signal();
        }
        finally {
            lock.unlock();
        }
    }

    private void signalPerf() {
        ReentrantLock lock = this.consumePerfLock;
        lock.lock();
        try {
            this.perfCondition.signal();
        }
        finally {
            lock.unlock();
        }
    }

    private List<T> drainTo(BlockingQueue<T> queue) {
        ArrayList list = new ArrayList();
        queue.drainTo(list, this.batchSize);
        this.setLastConsumeTimeMillis();
        return list;
    }

    private BlockingQueue<T> determineQueue() {
        if (!this.isStarted) {
            throw new IllegalStateException("not started yet!");
        }
        boolean isCurrentInPerfTestMode = InternalPerfTestContext.isCurrentInPerfTestMode();
        if (isCurrentInPerfTestMode) {
            this.lastPerfTestSceneId = InternalPerfTestContext.getCurrentSceneId();
            this.isLastTestCluster = InternalPerfTestContext.isTestCluster();
        }
        return isCurrentInPerfTestMode ? this.queue4PerfTest : this.queue4Normal;
    }

    public synchronized void start() {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        if (this.maxWaitTimeMillis > 0) {
            this.scheduleThread.start();
        }
        this.batchConsumeNormalThread.start();
        this.batchConsumePerfThread.start();
    }

    public synchronized void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        if (this.maxWaitTimeMillis > 0) {
            this.scheduleThread.interrupt();
        }
        this.signalNormal();
        this.batchConsumePerfThread.interrupt();
    }

    private boolean needWait(BlockingQueue<T> queue) {
        return this.sizeWait(queue) && this.timeOutWait(queue);
    }

    private boolean sizeWait(BlockingQueue<T> queue) {
        if (this.maxWaitSize <= 0) {
            return true;
        }
        return queue.size() < this.maxWaitSize;
    }

    private boolean timeOutWait(BlockingQueue<T> queue) {
        if (this.maxWaitTimeMillis <= 0) {
            return true;
        }
        return queue.isEmpty() || this.getWaitTime() < (long)this.maxWaitTimeMillis;
    }

    private long getWaitTime() {
        return System.currentTimeMillis() - this.getLastConsumeTimeMillis();
    }

    private void setLastConsumeTimeMillis() {
        if (InternalPerfTestContext.isCurrentInPerfTestMode()) {
            this.lastConsumeTimeMillis4PerfTest = System.currentTimeMillis();
        } else {
            this.lastConsumeTimeMillis4Normal = System.currentTimeMillis();
        }
    }

    private long getLastConsumeTimeMillis() {
        return InternalPerfTestContext.isCurrentInPerfTestMode() ? this.lastConsumeTimeMillis4PerfTest : this.lastConsumeTimeMillis4Normal;
    }

    public boolean add(T t) {
        BlockingQueue<T> queue = this.determineQueue();
        boolean added = queue.add(t);
        if (added) {
            this.signal();
        }
        return added;
    }

    public boolean offer(T t) {
        BlockingQueue<T> queue = this.determineQueue();
        boolean added = queue.offer(t);
        if (added) {
            this.signal();
        }
        return added;
    }

    public boolean offer(T t, long timeout, TimeUnit unit) throws InterruptedException {
        BlockingQueue<T> queue = this.determineQueue();
        boolean added = queue.offer(t, timeout, unit);
        if (added) {
            this.signal();
        }
        return added;
    }

    public void put(T t) throws InterruptedException {
        BlockingQueue<T> queue = this.determineQueue();
        queue.put(t);
        this.signal();
    }

    public int size() {
        return this.determineQueue().size();
    }

    public boolean isEmpty() {
        return this.determineQueue().isEmpty();
    }

    public boolean contains(Object o) {
        return this.determineQueue().contains(o);
    }

    public Iterator<T> iterator() {
        return this.determineQueue().iterator();
    }

    public Object[] toArray() {
        return this.determineQueue().toArray();
    }

    public String toString() {
        return this.determineQueue().toString();
    }
}

