package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 客户状态，根据客户所处资源池类型转换而来
 * @see OtoCustPoolEnum
 *
 * @author ZhangJun
 * @date 2022/2/25 09:59
 */
@Getter
@AllArgsConstructor
public enum OtoCustStatusEnum {

    WAIT_ASSIGN(0, "待分配"),
    ASSIGNED(1, "跟进中"),
    RECYCLED(2, "回收池"),
    GARBAGE_POOL(3,"垃圾池")
    ;

    /**
     * 客户状态
     */
    private Integer custStatus;

    /**
     * 资源池描述
     */
    private String desc;

}
