package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuanhongjian
 */
@Getter
@AllArgsConstructor
public enum CustGenderEnum {
    /**
     * 客户性别
     */
    UNKNOWN("未知", 0),
    MALE("男性", 1),
    FEMALE("女性", 2);

    private final String desc;
    private final Integer code;
    private static final ImmutableMap<Integer, CustGenderEnum> INNER_MAP;
    static {
        ImmutableMap.Builder<Integer, CustGenderEnum> builder = ImmutableMap.builder();
        for (CustGenderEnum item : CustGenderEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    public static CustGenderEnum getByCode(Integer code) {
        return INNER_MAP.get(code)==null?UNKNOWN:INNER_MAP.get(code);
    }
}
