package cn.com.duiba.live.normal.service.api.dto.oto.cust;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.CustSourceEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 20:08
 */
@Data
public class OtoCustomerPageDto implements Serializable {

    private static final long serialVersionUID = -6352158074729359750L;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 客户价值
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustValueEnum
     */
    private Integer custValue;

    /**
     * 跟进客户权重
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustFollowWeightEnum
     */
    private Integer followWeight;

    /**
     * 上次跟进时间
     */
    private Date lastFollowTime;

    /**
     * 跟进状态
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustFollowStatusEnum
     */
    private Integer followStatus;

    /**
     * 跟进次数 = 打电话次数 + 面访次数 + 参观次数
     */
    private Integer followTimes;

    /**
     * 上次分配时间
     */
    private Date lastAssignTime;

    /**
     * 分配类型
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustAssignTypeEnum
     */
    private Integer assignType;

    /**
     * 标签
     */
    private List<String> tagNames;

    /**
     * 是否为星标客户
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer custStar;

    /**
     * 流程组状态
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.CustFlowEnum
     */
    private Integer custFlow;

    /**
     * @see CustSourceEnum
     */
    private Integer custSource;

    /**
     * 客户行为
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.CustActionTypeEnum
     */
    private String custActionType;

    /**
     * 客户系数
     */
    private Integer custCoefficient;

    /**
     * 手机号归属地
     */
    private String custArea;

    /**
     * 专家备注
     */
    private String expertRemark;

    /**
     * 客户出生年份
     */
    private Integer custAge;

    /**
     * 客户备注
     */
    private String custDescription;

    /**
     * 加微状态
     */
    private Integer addWxStatus;
    /**
     * 是否接通
     */
    private Integer callStatus;

    /**
     * 是否约到一面 0否 1是
     */
    private Integer firstInterviewFlag;

    /**
     * 约见时间
     */
    private Long interviewTime;

    /**
     * 见面次数 见面状态=已完成的 面访数
     */
    private Integer finishInterviewNum;

    /**
     * 最近一次面访备注
     */
    private String interviewRemark;

    /**
     * 电话次数
     */
    private Integer callNums;
}
