package cn.com.duiba.live.normal.service.api.enums.importtask;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 导入任务类型枚举
 *
 * @author xuzhigang
 * @date 2020/10/21 1:59 下午
 **/
@Getter
@AllArgsConstructor
public enum LiveImportTaskTypeEnum {
    UPLOAD_ACTIVATE_AGENT(1, "上传架构名单"),

    DELETE_ACTIVATE_AGENT(2, "删除架构名单"),

    BATCH_DELETE_PERMISSION(3, "业务员列表-批量删除权限"),

    BATCH_CHANGE_TEAM(4, "业务员列表-批量切换团队"),

    BATCH_UPDATE_AGENT(5, "业务员列表-批量更新信息"),

    LOTTERY_SPECIFY(6, "抽奖-中奖名单"),

    UPLOAD_ACTIVATE_AGENT_CUSTOM(7, "上传架构名单定制"),

    DELETE_ACTIVATE_AGENT_CUSTOM(8, "删除架构名单定制"),

    BATCH_DELETE_PERMISSION_CUSTOM(9, "业务员列表-批量删除权限定制"),

    BATCH_CHANGE_TEAM_CUSTOM(10, "业务员列表-批量切换团队定制"),

    BATCH_UPDATE_AGENT_CUSTOM(11, "业务员列表-批量更新信息定制"),

    BATCH_SET_VIP(12,"业务员列表-批量设置vip"),

    BATCH_DELETE_VIP(13,"业务员列表-批量取消vip"),

    UPLOAD_LIVE_AGENT_INVITE_AUTH(14, "上传参与邀约名单"),

    BATCH_DELETE_LIVE_AGENT_INVITE_AUTH(15, "批量删除代理人参与邀约名单"),

    BATCH_SET_AGENT_PRIVILEGE(16,"高级功能管理-批量设置代理人权限"),

    BATCH_IMPORT_GROUP_PROVIDER(17, "批量导入团队发奖人名单"),

    BATCH_IMPORT_AGENT_URL_RECORD(18, "批量导入代理人专属链接"),

    BATCH_IMPORT_LOTTERY_TEAM_NUM(19, "中奖规则-批量导入团队份数"),

    UPLOAD_TREASURE_TEAM_AWARD(20, "直播宝箱-上传团队奖励配置"),

    UPLOAD_AGENT_LIST_SPECIFY_AWARD(21, "指定中奖配置-上传代理人名单"),

    OTO_IMPORT_CUST(22, "OTO-导入第三方客户名单-刷数据"),

    OTO_IMPORT_CUST_CALL_LOG(23, "OTO-导入第三方客户通话记录-刷数据"),

    OTO_FORM_COMPANY_FIX(24, "OTO-表单所属公司-数据修复"),

    OTO_SELLER_COMPANY_FIX(25, "OTO-销售所属公司-数据销售"),

    OTO_CUST_POOL_TYPE_FIX(26, "OTO-将回收池客户改为垃圾池-数据修复"),

    OTO_CUST_FLOW_FIX(27, "OTO-客户所处流程组-数据修复"),

    OTO_INTERVIEW_RECORD_FIX(28, "OTO-客户面访记录-数据修复"),

    OTO_BATCH_IMPORT_CUSTOMER_TASK(29, "OTO-批量导入客户任务"),

    MALL_PICK_GOODS_IMPORT(30,"商城-批量导入选品"),

    MALL_GOODS_CATEGORY_IMPORT(31, "商城-批量导入商品类目"),

    MALL_OEDER_AUTH_IMPORT(32, "商城-批量审核"),

    MALL_OEDER_SHIPPING_IMPORT(33, "商城-批量发货"),
    ;

    /**
     * 导入任务类型
     */
    private final Integer taskType;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, LiveImportTaskTypeEnum> MAP = new HashMap<>();

    static {
        Arrays.stream(values()).forEach(type -> MAP.put(type.getTaskType(), type));
    }

    /**
     * 根据type获取枚举
     */
    public static LiveImportTaskTypeEnum getEnumByType(Integer type) {
        return MAP.get(type);
    }
}
