package cn.com.duiba.live.normal.service.api.enums.kuaidi100;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 物流状态枚举
 * 包括0在途，1揽收，2疑难，3签收，4退签，5派件，6退回，7转投，10待清关，11清关中，12已清关，13清关异常，14拒签
 *
 * @author xuzhigang
 * @date 2022/9/2 4:32 下午
 **/
@Getter
@AllArgsConstructor
public enum ExpressStateEnum {
    NO_EXPRESS(-99, "没有物流"),
    WAIT_COLLECTION(-1,"待揽收"),
    ON_THE_WAY(0, "在途"),
    COLLECTION(1, "揽收"),
    DIFFICULT(2, "疑难"),
    SING(3, "签收"),
    CANCELLATION(4, "退签"),
    DISPATCH(5, "派件"),
    RETURN(6, "退回"),
    SWITCH(7,"转投"),
    PENDING_CUSTOMS_CLEARANCE(10, "待清关"),
    CLEARING_CUSTOMS(11,"清关中"),
    CLEARED(12,"已清关"),
    CUSTOMS_CLEARANCE_EXCEPTION(13,"清关异常"),
    REFUSAL(14,"拒签"),
    ;

    private final int state;

    private final String desc;

    private static Map<Integer, String> map = new HashMap<>();

    static {
        for (ExpressStateEnum value : values()) {
            map.put(value.getState(), value.getDesc());
        }
    }

    public static String getByState(Integer state) {
        return map.get(state);
    }
}
