package cn.com.duiba.live.normal.service.api.enums.oto.interview;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.Getter;

/**
 * @author xuanhongjian
 */
@Getter
public enum EvaluateDetailEnum {
    /**
     * 1:销售介绍不符合我的养老情况2:销售态度我很满意 3:这次体验让我很开心 4:销售介绍的很详细 50:销售介绍不符合我的养老情况 51:销售服务态度我不满意
     * 52:这次体验让我感觉到不舒适 53:销售介绍没有重点
     */
    GOOD_ONE(1, "销售介绍不符合我的养老情况"),
    GOOD_TWO(2, "销售态度我很满意"),
    GOOD_THREE(3, "这次体验让我很开心"),
    GOOD_FOUR(4, "销售介绍的很详细"),
    BAD_ONE(50, "销售介绍不符合我的养老情况"),
    BAD_TWO(51, "销售服务态度我不满意"),
    BAD_THREE(52, "这次体验让我感觉到不舒适"),
    BAD_FOUR(53, "销售介绍没有重点");
    private static final ImmutableMap<Integer, EvaluateDetailEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, EvaluateDetailEnum> builder = ImmutableMap.builder();
        for (EvaluateDetailEnum item : EvaluateDetailEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    private final Integer code;
    private final String desc;

    EvaluateDetailEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EvaluateDetailEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

}
