package cn.com.duiba.live.normal.service.api.remoteservice.oto.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.OtoCustCheckDto;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-10-11 13:51
 */
@AdvancedFeignClient
public interface RemoteOtoCustCheckService {

    /**
     * 根据客户id查询最近一次盘点记录
     *
     * @param custId 客户id
     * @return 客户信息
     */
    OtoCustCheckDto findLastByCustId(Long custId);

    /**
     * 保存盘点记录
     *
     * @param otoCustCheckDto
     * @return
     */
    int saveRecord(OtoCustCheckDto otoCustCheckDto);

    /**
     * 获取盘点记录
     *
     * @param custId
     * @return
     */
    List<OtoCustCheckDto> findByCustId(Long custId);
}
