package cn.com.duiba.live.normal.service.api.enums.oto.cust.log;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-06 18:11
 */
@Getter
@AllArgsConstructor
public enum OtoCustomerOptKeyEnum {

    CUST_VALUE("custValue", "客户价值"),
    CUST_TAG("custTag", "客户标签"),
    CUST_MEET("custMeet", "客户面访"),
    CUST_ORDER_VISIT("custOrderVisit", "客户预约参观"),
    CUST_FEEDBACK_VISIT("custFeedbackVisit", "客户反馈参观"),
    CUST_CALL("custCall", "打电话给客户"),
    CUST_FOLLOW_WEIGHT("followWeight", "客户关注度"),

    CUST_NAME("custName", "客户姓名"),
    CUST_AREA("custArea", "省市区"),
    CUST_DESC("custDescription", "备注"),
    CUST_AGE("custAge", "年龄"),
    CUST_EXT_ADD_WX("addWxStatus", "加微状态"),
    CUST_EXT_DEAL_FLAG("dealFlag", "是否成交"),
    CUST_EXT_CUST_STATUS("commitCustStatus", "提交计划书后客户状态"),
    CUST_EXT_COMMIT_PLAN("commitPlanFlag", "是否提交养老规划方案"),
    CUST_EXT_CORE_MAKER("coreMaker", "核心决策人"),
    CUST_EXT_VISIT_PROGRESS("visitProgress", "参观进度"),
    CUST_EXT_FOR_WHO("forWho", "为谁考虑"),
    CUST_EXT_ROOMER_AGE("roomerAge", "入住人年龄"),
    CUST_EXT_ROOMER_CITY("roomerCity", "入住人城市"),
    CUST_EXT_REASON("considerReason", "考虑原因"),
    CUST_EXT_PRESSURE("payPressure", "付费压力"),
    CUST_EXT_MONEY("retireMoney", "退休金"),
    CUST_EXT_VISIT_ORG("visitOrg", "参观机构"),
    CUST_EXT_HAS_MONEY("hasMoney", "资金情况"),
    CUST_EXT_HAS_HOUSE("hasHouse", "房产情况"),
    CUST_EXT_ATTITUDE("familyAttitude", "家人态度"),
    CUST_EXT_IDEA_AGREE("idea_agree", "理念是否认同"),
    CUST_EXT_INS_APPLICANT("ins_applicant", "投保人"),
    CUST_EXT_INS_BY_APPLICANT("ins_by_applicant", "被投保人"),
    CUST_EXT_INS_MONEY("ins_money", "投保金额"),
    CUST_EXT_INS_PERIOD("ins_period", "投保期数"),
    CUST_EXT_COMMIT_INSURE("commitInsure", "客户是否已确认投保要素"),
    CUST_EXT_INSURE_REASON("insureReason", "客户未确认投保要素的原因"),
    CUST_EXT_PRODUCT("product", "客户选择的产品"),
    ;

    /**
     * key值
     */
    private final String key;

    /**
     * 描述
     */
    private final String desc;
}
