package cn.com.duiba.live.normal.service.api.remoteservice.pub.form;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.common.PhoneLocationDto;
import cn.com.duiba.live.normal.service.api.dto.pub.form.PubFormRecordDto;
import cn.com.duiba.live.normal.service.api.param.oto.pubform.PubFormRecordQueryListParam;

import java.util.Date;
import java.util.List;

/**
 * @author zhuenhui
 * @date 2021/09/29 16:20
 * @description 公域流量 - 表单测试记录 RPC 接口
 */
@AdvancedFeignClient
public interface RemotePubFormRecordApiService {

    /**
     * 插入记录
     *
     * @param dto 测试记录
     * @return 记录主键
     */
    Long insert(PubFormRecordDto dto);

    /**
     * 更新验证状态
     *
     * @param recordId 主键
     * @return 执行结果
     */
    int updateAuthStatus(Long recordId);

    /**
     * 查询提交记录
     *
     * @param recordId 主键
     * @return 提交记录
     */
    PubFormRecordDto findById(Long recordId);

    /**
     * 根据表单ID和手机号批量查询处URL_Link
     * 用于数据上报
     * @param formId 表单ID
     * @param phoneNums 手机号列表
     * @return UrlLinkList
     */
    List<String> batchSelectUrlLinkByFormIdAndPhone(Long formId, List<String> phoneNums);

    /**
     * 批量插入记录
     *
     * @param list 测试记录列表
     * @return 主键
     */
    List<Long> batchInsert(List<PubFormRecordDto> list);

    /**
     * 通过id批量修改验证状态
     *
     * @param list 主键集合
     * @return 执行结果
     */
    int batchUpdateAuthStatus(List<Long> list);

    /**
     * 查询提交记录 一次查询100条 - 管理后台专用
     *
     * @param formId  表单Id
     * @param startId 开始查询Id
     * @return 记录列表
     */
    List<PubFormRecordDto> listByFormId(Long formId, Long startId);

    /**
     * 查询提交记录
     *
     * @param recordIds 提交记录Id
     * @return 记录列表
     */
    List<PubFormRecordDto> listByIds(List<Long> recordIds);

    /**
     * 通过条件查询
     * @deprecated 使用 {@link #findPageByCondition}
     * @param formId 表单id
     * @param phoneNum 手机号
     * @param recordLabel 标签
     * @return 记录列表
     */
    @Deprecated
    List<PubFormRecordDto> selectPageByCondition(Long formId, String phoneNum, Integer recordLabel, Integer offset, Integer pageSize);

    /**
     * 通过条件统计个数
     * @deprecated 使用 {@link #getCountByCondition}
     * @param formId 表单id
     * @param phoneNum 手机号
     * @param recordLabel 标签
     * @return 统计个数
     */
    @Deprecated
    int countByCondition(Long formId, String phoneNum, Integer recordLabel, Integer offset, Integer pageSize);

    /**
     * 通过条件查询
     * @param queryParam 查询条件
     * @return 记录列表
     */
    List<PubFormRecordDto> findPageByCondition(PubFormRecordQueryListParam queryParam);

    /**
     * 通过条件统计个数
     * @param queryParam 查询条件
     * @return 统计个数
     */
    int getCountByCondition(PubFormRecordQueryListParam queryParam);

    /**
     * 修改标签和评论
     * @param recordId 记录id
     * @param recordLabel  标签
     * @param recordRemark 评论
     * @return 结果
     */
    int updateRecordLabel(Long recordId, Integer recordLabel, String recordRemark);

    /**
     * 修改操作人员
     * @param recordId 记录id
     * @param recordEditor 操作人员
     * @return 结果
     */
    int updateRecordEditor(Long recordId, String recordEditor);

    /**
     * 修改回传状态
     * @param recordId 记录id
     * @param callBackStatus 回传状态
     * @return 结果
     */
    int updateCallBackStatus(Long recordId, Integer callBackStatus);

    /**
     * 根据手机号查询最近填写的表单记录
     *
     * @param phoneNum 手机号
     * @return 表单记录
     */
    PubFormRecordDto findRecentlyRecordByPhone(String phoneNum);

    /**
     * 瀑布流查询，按照id倒序
     *
     * @param lastMaxId 上次查询的最大id
     * @param pageSize 查询数量
     * @return 查询结果
     */
    List<PubFormRecordDto> findWithWaterFall(Long lastMaxId, Long stopId, Integer pageSize);

    /**
     * 根据主键批量更新归属地
     *
     * @param locationDtos 归属地dto
     * @return 更新成功数量
     */
    int batchUpdateLocation(List<PhoneLocationDto> locationDtos);

    /**
     * 更新提交记录
     * @param pubFormRecordDto 提交记录dto
     * @return 更新成功数量
     */
    boolean modifyRecord(PubFormRecordDto pubFormRecordDto);

    /**
     * 瀑布流查询有效、未回传、当前时间-3min
     * @param lastMaxId 最大id
     * @param pageSize 当前页大小
     * @param recentlyTime 最近时间
     * @return 查询结果
     */
    List<PubFormRecordDto> findValidRecordWithWaterFall(Long lastMaxId, int pageSize, Date recentlyTime);

    /**
     * 根据手机号查询验证过的表单记录
     *
     * @param phoneNums 手机号
     * @return 表单记录
     */
    List<PubFormRecordDto> findRecordByPhones(List<String>  phoneNums);
}
