package cn.com.duiba.live.normal.service.api.enums.oto.cust.follow;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-05 19:54
 * 客户跟进状态枚举
 */
@AllArgsConstructor
@Getter
public enum OtoCustFollowStatusEnum {

    CONTACT(1, "需要联系"),
    MEET(2, "需要约见"),
    PLAN(3, "要发计划书"),
    TO_DEAL(4, "待促成"),
    DEAL(5, "已成单");

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 备注
     */
    private final String desc;

    private static final Map<Integer, String> FOLLOW_STATUS_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustFollowStatusEnum::getStatus, OtoCustFollowStatusEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据状态获取描述
     */
    public static String getDescByStatus(Integer status){
        if (status == null) {
            return null;
        }
        return FOLLOW_STATUS_MAP.get(status);
    }
}
