package cn.com.duiba.live.normal.service.api.remoteservice.help;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.help.LiveCommonHelpDto;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2021/05/20 5:12 下午
 * @description 通用助力服务接口
 */
@AdvancedFeignClient
public interface RemoteLiveCommonHelpApiService {

    /**
     * 异步写入，根据唯一键约束先查后写，并限制写入频率
     * @param list 通用助力信息列表
     */
    void asyncBatchInsertUniqueAndLimiter(List<LiveCommonHelpDto> list);

    /**
     * 通过id批量修改is_agent为1(邀请人为代理人)
     *
     * @param list 主键集合
     * @return 修改数量
     */
    int updateIsAgentByIds(List<Long> list);

}
