/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.statistics.service.api.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.apache.shardingsphere.encrypt.strategy.spi.Encryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AesEncrypt
implements Encryptor {
    private static final Logger log = LoggerFactory.getLogger(AesEncrypt.class);
    private static final String AES_KEY = "aes.key.value";
    private Properties properties = new Properties();

    public void init() {
    }

    public String encrypt(Object plaintext) {
        if (null == plaintext) {
            return null;
        }
        return this.aesEncrypt(String.valueOf(plaintext));
    }

    private String aesEncrypt(String plaintext) {
        if (StringUtils.isBlank((String)plaintext)) {
            return plaintext;
        }
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, this.getSecretKey());
            byte[] clearText = plaintext.getBytes(StandardCharsets.UTF_8);
            byte[] cipherTextBytes = cipher.doFinal(clearText);
            return Base64.getEncoder().encodeToString(cipherTextBytes);
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
            return null;
        }
    }

    public Object decrypt(String cipherText) {
        return this.aesDecrypt(cipherText);
    }

    private String aesDecrypt(String content) {
        if (StringUtils.isBlank((String)content)) {
            return content;
        }
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, this.getSecretKey());
            byte[] original = cipher.doFinal(Base64.getDecoder().decode(content));
            return new String(original, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return content;
        }
    }

    private SecretKey getSecretKey() throws Exception {
        try {
            byte[] keyBytes = Arrays.copyOf(this.properties.get(AES_KEY).toString().getBytes(StandardCharsets.UTF_8), 16);
            return new SecretKeySpec(keyBytes, "AES");
        }
        catch (Exception ex) {
            log.error("\u52a0\u5bc6\u79d8\u94a5\u5931\u8d25", (Throwable)ex);
            throw new Exception("\u52a0\u5bc6\u79d8\u94a5\u5931\u8d25");
        }
    }

    public String getType() {
        return "CustomAes";
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

