package cn.com.duiba.live.statistics.service.api.dto.live;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播统计-每场直播维度统计信息
 * @author kjj mybatis generator
 * @date 2020-04-03
 */
@Data
public class LiveStatisticsDto implements Serializable {

    private static final long serialVersionUID = 15859053067453715L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 邀请人数
     */
    private Integer invitationNum;

    /**
     * 观看人数
     */
    private Integer visitorNum;

    /**
     * 裂变人数
     */
    private Integer fissionNum;

    /**
     * 线索数
     */
    private Integer clueNum;

    /**
     * 评论数
     */
    private Integer speakNum;

    /**
     * 新增关注人数
     */
    private Integer subscribeNum;

    /**
     * 访客平均观看时长
     */
    private Integer visitorAveDuration;

    /**
     * 直播总分
     */
    private Integer clueTotalScore;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
