package cn.com.duiba.live.statistics.service.api.enums.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 客户保险意识枚举
 *
 * @author ZhangJun
 * @date 2021/7/2 5:01 下午
 */
@Getter
@AllArgsConstructor
public enum InsuranceAwarenessEnum {

    /**
     * 未知
     */
    UN_KNOW(null, "未知"),

    /**
     * 弱
     */
    BAD(0, "弱"),

    /**
     * 较弱
     */
    WEAK(1, "较弱"),

    /**
     * 中
     */
    NORMAL(2, "中"),

    /**
     * 较强
     */
    GOOD(3, "较强"),

    /**
     * 强
     */
    BETTER(4, "强"),
    ;


    /**
     * 是否持保
     */
    private final Integer insuranceAwareness;

    /**
     * 描述
     */
    private final String desc;


    private static final Map<Integer, InsuranceAwarenessEnum> ENUM_MAP = new HashMap<>();

    static {
        for (InsuranceAwarenessEnum item : values()) {
            ENUM_MAP.put(item.getInsuranceAwareness(), item);
        }
    }

    /**
     * 是否存在该枚举字段
     */
    public static boolean existEnum(Integer insuranceAwareness) {
        return Objects.nonNull(ENUM_MAP.get(insuranceAwareness));
    }

}
